----------------
title : C 언어 레퍼런스 - free 함수
cat_title :  free
ref_title : free
path : /C Reference/stdlib.h
----------------

##@ cpp-ref-start

#@ free

`stdlib.h` 에 정의됨

```cpp-formatted
void free(void* ptr);
```

**메모리를 해제한다**

이전에 `malloc` 혹은 `calloc, realloc` 등으로 할당된 메모리를 해제해서, 나중에 다시 사용될 수 있게 합니다.

만일 `ptr` 이 위의 함수들도 할당된 메모리를 가리키지 않는다면, **무슨일이 일어날지는 아무도 모릅니다(undefined behavior)**.

만일 `ptr` 이 널 포인터라면, 위 함수는 아무것도 하지 않습니다.

### 인자들

기존에 `malloc, callor, realloc` 으로 할당된 메모리의 시작점을 가리키는 포인터

### 리턴값

없음

### 실행 예제

```cpp-formatted
/* free example */
#include <stdlib.h> /* malloc, calloc, realloc, free */

int main() {
  int *buffer1, *buffer2, *buffer3;
  buffer1 = (int*)malloc(100 * sizeof(int));
  buffer2 = (int*)calloc(100, sizeof(int));
  buffer3 = (int*)realloc(buffer2, 500 * sizeof(int));
  free(buffer1);
  free(buffer3);
  return 0;
}
```

실행 결과

```exec
(잘 실행 된다.)
```

### 참고 자료

* `malloc` : 메모리를 할당한다.
* `calloc` : 0 으로 초기화된 메모리를 할당한다.
* `realloc` : 메모리를 재할당 한다.